/*:
 * @plugindesc Allows you to add/customize backgrounds and change window opacity for all menu scenes.
 * @author SumRndmDde
 *
 * @param Scale Background
 * @desc Set this to 'true' and the backgrounds will automatically scale to the window size.
 * @default true
 *
 * @param == Main Menu ==
 * @default
 *
 * @param Menu Background
 * @desc The background used for the main menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Menu Opacity
 * @desc The opacity of the windows in the main menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Menu Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Menu Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Item Menu ==
 * @default
 *
 * @param Item Background
 * @desc The background used for the item menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Item Opacity
 * @desc The opacity of the windows in the item menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Item Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Item Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Skill Menu ==
 * @default
 *
 * @param Skill Background
 * @desc The background used for the skill menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Skill Opacity
 * @desc The opacity of the windows in the skill menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Skill Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Skill Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Equip Menu ==
 * @default
 *
 * @param Equip Background
 * @desc The background used for the equip menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Equip Opacity
 * @desc The opacity of the windows in the equip menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Equip Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Equip Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Status Menu ==
 * @default
 *
 * @param Status Background
 * @desc The background used for the status menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Status Opacity
 * @desc The opacity of the windows in the status menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Status Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Status Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Save Menu ==
 * @default
 *
 * @param Save Background
 * @desc The background used for the save menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Save Opacity
 * @desc The opacity of the windows in the save menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Save Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Save Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Options Menu ==
 * @default
 *
 * @param Options Background
 * @desc The background used for the options menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Options Opacity
 * @desc The opacity of the windows in the options menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Options Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Options Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == End Menu ==
 * @default
 *
 * @param End Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param End Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param End Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param End Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 1 ==
 * @default
 *
 * @param Custom 1 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 1 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 1 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 1 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 1 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 2 ==
 * @default
 *
 * @param Custom 2 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 2 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 2 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 2 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 2 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 3 ==
 * @default
 *
 * @param Custom 3 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 3 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 3 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 3 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 3 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 4 ==
 * @default
 *
 * @param Custom 4 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 4 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 4 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 4 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 4 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 5 ==
 * @default
 *
 * @param Custom 5 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 5 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 5 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 5 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 5 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 6 ==
 * @default
 *
 * @param Custom 6 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 6 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 6 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 6 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 6 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 7 ==
 * @default
 *
 * @param Custom 7 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 7 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 7 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 7 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 7 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 8 ==
 * @default
 *
 * @param Custom 8 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 8 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 8 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 8 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 8 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 9 ==
 * @default
 *
 * @param Custom 9 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 9 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 9 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 9 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 9 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 10 ==
 * @default
 *
 * @param Custom 10 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 10 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 10 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 10 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 10 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 11 ==
 * @default
 *
 * @param Custom 11 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 11 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 11 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 11 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 11 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 12 ==
 * @default
 *
 * @param Custom 12 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 12 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 12 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 12 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 12 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 13 ==
 * @default
 *
 * @param Custom 13 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 13 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 13 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 13 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 13 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 14 ==
 * @default
 *
 * @param Custom 14 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 14 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 14 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 14 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 14 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 15 ==
 * @default
 *
 * @param Custom 15 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 15 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 15 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 15 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 15 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 16 ==
 * @default
 *
 * @param Custom 16 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 16 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 16 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 16 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 16 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 17 ==
 * @default
 *
 * @param Custom 17 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 17 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 17 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 17 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 17 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 18 ==
 * @default
 *
 * @param Custom 18 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 18 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 18 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 18 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 18 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 19 ==
 * @default
 *
 * @param Custom 19 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 19 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 19 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 19 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 19 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @param == Custom 20 ==
 * @default
 *
 * @param Custom 20 Scene
 * @desc The name of the custom menu's scene
 * @default
 *
 * @param Custom 20 Background
 * @desc The background used for the end menu screen.
 * Place it in img/SumRndmDde/menu/
 * @default
 *
 * @param Custom 20 Opacity
 * @desc The opacity of the windows in the end menu screen.
 * Set to a number between 0 and 255
 * @default 255
 *
 * @param Custom 20 Scale
 * @desc The base scale of the background image.
 * 1 is a normal scale; 0.5 is half; 2 is double; etc...
 * @default 1
 *
 * @param Custom 20 Motion
 * @desc The motion of the background image.
 * Visit the HELP section for a list of motions.
 * @default
 *
 * @help
 *
 * Menu Backgrounds
 * Version 2.05
 * SumRndmDde
 *
 * 
 * This allows you to give all the menu pages of your menu custom 
 * backgrounds!
 *
 * You can control the scale of the background images, the opacity of the 
 * windows in the menus, and the motion of the background images.
 *
 * 
 * ==============================================================================
 *  How to set up the images
 * ==============================================================================
 *
 * Place all the background images you wish to use in:
 * 
 * img/SumRndmDde/menu
 *
 * (this is so that when you export your game, all you have to do is copy
 * the SumRndmDde folder inside of the img folder to the exported game files)
 *
 * Anyway, simply input the picture's name without the file extension 
 * into the Parameter of choice and it should work perfectly.
 *
 *
 * ==============================================================================
 *  How to set up Custom Scenes
 * ==============================================================================
 *
 * In order to set up a background for a custom menu scene, input the scene's
 * name in a "Custom X Scene". Then input all of the other informtion you wish
 * for that scene to have within the other Custom X parameters.
 *
 *
 * ==============================================================================
 *  Background Image Motions
 * ==============================================================================
 *
 * Here is a list of all the motions that can be used in the "Motion" parameters:
 *
 * ==============================================================================
 *
 *   scroll [xSpeed] [ySpeed]
 *
 * This makes it so the background scrolls at the X and Y speeds provided.
 *
 * Here is an example:
 *    scroll 3 3
 *
 * ==============================================================================
 *
 *   zoom [zoomSpeed] [maxZoom]
 *
 * This makes the background image zooms in and out at a certain speed.
 *
 * Here is an example:
 *    zoom 0.01 5
 *
 * ==============================================================================
 *
 *   rotate [rotateSpeed] [maxRotate]
 *
 * This makes the background image rotate at a certain speed.
 *
 * Here is an example:
 *    rotate 0.01 0.5
 *
 * ==============================================================================
 *
 *   blur [blurSpeed] [maxBlur]
 *
 * This makes the background image blur at a certain speed.
 *
 * Here is an example:
 *    blur 0.01 1
 *
 *
 * ==============================================================================
 *  End of Help File
 * ==============================================================================
 * 
 * Welcome to the bottom of the Help file.
 *
 *
 * Thanks for reading!
 * If you have questions, or if you enjoyed this Plugin, please check
 * out my YouTube channel!
 *
 * https://www.youtube.com/c/SumRndmDde
 *
 *
 * Until next time,
 *   ~ SumRndmDde
 */

var SRD = SRD || {};
SRD.MenuBackgrounds = SRD.MenuBackgrounds || {};

var Imported = Imported || {};
Imported["SumRndmDde Menu Backgrounds"] = 2.05;

(function(_) {

"use strict";

//-----------------------------------------------------------------------------
// SRD.MenuBackgrounds
//-----------------------------------------------------------------------------

const params = PluginManager.parameters('SRD_MenuBackgrounds');

_.scale = String(params['Scale Background']).trim().toLowerCase() === 'true';

_.backgrounds = {};
_.backgrounds["Scene_Menu"] = String(params['Menu Background']);
_.backgrounds["Scene_Item"] = String(params['Item Background']);
_.backgrounds["Scene_Skill"] = String(params['Skill Background']);
_.backgrounds["Scene_Equip"] = String(params['Equip Background']);
_.backgrounds["Scene_Status"] = String(params['Status Background']);
_.backgrounds["Scene_Save"] = String(params['Save Background']);
_.backgrounds["Scene_Options"] = String(params['Options Background']);
_.backgrounds["Scene_GameEnd"] = String(params['End Background']);

_.opacity = {};
_.opacity["Scene_Menu"] = parseInt(params['Menu Opacity']);
_.opacity["Scene_Item"] = parseInt(params['Item Opacity']);
_.opacity["Scene_Skill"] = parseInt(params['Skill Opacity']);
_.opacity["Scene_Equip"] = parseInt(params['Equip Opacity']);
_.opacity["Scene_Status"] = parseInt(params['Status Opacity']);
_.opacity["Scene_Save"] = parseInt(params['Save Opacity']);
_.opacity["Scene_Options"] = parseInt(params['Options Opacity']);
_.opacity["Scene_GameEnd"] = parseInt(params['End Opacity']);

_.scales = {};
_.scales["Scene_Menu"] = parseFloat(params['Menu Scale']);
_.scales["Scene_Item"] = parseFloat(params['Item Scale']);
_.scales["Scene_Skill"] = parseFloat(params['Skill Scale']);
_.scales["Scene_Equip"] = parseFloat(params['Equip Scale']);
_.scales["Scene_Status"] = parseFloat(params['Status Scale']);
_.scales["Scene_Save"] = parseFloat(params['Save Scale']);
_.scales["Scene_Options"] = parseFloat(params['Options Scale']);
_.scales["Scene_GameEnd"] = parseFloat(params['End Scale']);

_.motions = {};
_.motions["Scene_Menu"] = String(params['Menu Motion']);
_.motions["Scene_Item"] = String(params['Item Motion']);
_.motions["Scene_Skill"] = String(params['Skill Motion']);
_.motions["Scene_Equip"] = String(params['Equip Motion']);
_.motions["Scene_Status"] = String(params['Status Motion']);
_.motions["Scene_Save"] = String(params['Save Motion']);
_.motions["Scene_Options"] = String(params['Options Motion']);
_.motions["Scene_GameEnd"] = String(params['End Motion']);

for(let i = 1; i <= 20; i++) {
	const scene = String(params['Custom ' + i + ' Scene']);
	if(scene.trim().length > 0) {
		_.backgrounds[scene] = String(params['Custom ' + i + ' Background']);
		_.opacity[scene] = parseInt(params['Custom ' + i + ' Opacity']);
		_.scales[scene] = String(params['Custom ' + i + ' Scale']);
		_.motions[scene] = String(params['Custom ' + i + ' Motion']);
	}
}

_.loadImage = function(filename, hue) {
	return ImageManager.loadBitmap('img/SumRndmDde/menu/', filename, hue, true);
};

_.loadAllImages = function() {
	for (let property in _.backgrounds) {
		if (_.backgrounds.hasOwnProperty(property)) {
			const name = _.backgrounds[property];
			if(name.trim().length > 0) {
				_.loadImage(name);
			}
		}
	}
};

_.loadAllImages();

//-----------------------------------------------------------------------------
// Scene_MenuBase
//-----------------------------------------------------------------------------

_.Scene_MenuBase_create = Scene_MenuBase.prototype.create;
Scene_MenuBase.prototype.create = function() {
	this._menuBackgroundConstructorName = String(this.constructor.name);
	_.Scene_MenuBase_create.apply(this, arguments);
};

_.Scene_MenuBase_start = Scene_MenuBase.prototype.start;
Scene_MenuBase.prototype.start = function() {
	_.Scene_MenuBase_start.apply(this, arguments);
	this.setupWindowOpacities();	
};

Scene_MenuBase.prototype.setupWindowOpacities = function() {
	if(!this._windowLayer) return;
	const opac = _.opacity[this._menuBackgroundConstructorName];
	const childs = this._windowLayer.children;
	if((opac || opac === 0) && childs) {
		for(let i = 0; i < childs.length; i++) {
			const win = childs[i];
			if(win._isWindow) {
				win.opacity = opac;
			}
		}
	}

};

_.Scene_MenuBase_createBackground = Scene_MenuBase.prototype.createBackground;
Scene_MenuBase.prototype.createBackground = function() {
	if(_.backgrounds[this._menuBackgroundConstructorName]) {
		this._backgroundSprite = new TilingSprite();
		this._backgroundSprite.anchor.x = 0.5;
		this._backgroundSprite.anchor.y = 0.5;
		this._backgroundSprite.origin.x  = -(Graphics.boxWidth / 2);
		this._backgroundSprite.origin.y  = -(Graphics.boxHeight / 2);
		this._backgroundSprite.move(Graphics.boxWidth/2, Graphics.boxHeight/2, Graphics.boxWidth, Graphics.boxHeight);
		const bit = _.loadImage(_.backgrounds[this._menuBackgroundConstructorName]);
		let newWidth = bit.width;
		let newHeight = bit.height;
		if(_.scale) {
			newWidth = Graphics.boxWidth;
			newHeight = Graphics.boxHeight;
		}
		this._backgroundSprite.bitmap = new Bitmap(newWidth, newHeight);
		this._backgroundSprite.bitmap.blt(bit, 0, 0, bit.width, bit.height, 0, 0, newWidth, newHeight);
		this.addChild(this._backgroundSprite);
		this.createBackgroundMotion();
		this.createBackgroundScale();
		if(Utils.RPGMAKER_VERSION && Utils.RPGMAKER_VERSION >= '1.3.0') this.createBackgroundBlur();
	} else {
		_.Scene_MenuBase_createBackground.call(this);
	}
};

Scene_MenuBase.prototype.createBackgroundMotion = function() {
	if(_.motions[this._menuBackgroundConstructorName]) {
		const motion = _.motions[this._menuBackgroundConstructorName];
		if(!motion) {
			this._hasBackgroundMotion = false;
			this._backgroundMotionInfo = [''];
			return;
		}
		this._hasBackgroundMotion = true;
		this._backgroundMotionInfo = motion.split(' ');
		for(let i = 1; i < this._backgroundMotionInfo.length; i++) {
			this._backgroundMotionInfo[i] = parseFloat(this._backgroundMotionInfo[i]);
		}
		this._backgroundMotionSign = 1;
	}
};

Scene_MenuBase.prototype.createBackgroundScale = function() {
	if(_.scales[this._menuBackgroundConstructorName]) {
		this._backgroundMotionScale = _.scales[this._menuBackgroundConstructorName];
	} else {
		this._backgroundMotionScale = 1;
	}
	this._backgroundSprite.scale.x = this._backgroundMotionScale;
	this._backgroundSprite.scale.y = this._backgroundMotionScale;
};

Scene_MenuBase.prototype.createBackgroundBlur = function() {
	this._backgroundMotionFilter = new PIXI.filters.BlurFilter();
	this._backgroundMotionFilter.blur = 0;
	this._backgroundSprite.filters = [this._backgroundMotionFilter];
};

_.Scene_MenuBase_update = Scene_MenuBase.prototype.update;
Scene_MenuBase.prototype.update = function() {
	_.Scene_MenuBase_update.apply(this, arguments);
	if(this._hasBackgroundMotion) {
		this.updateBackgroundMotion();
	}
};

Scene_MenuBase.prototype.updateBackgroundMotion = function() {
	const motionType = this._backgroundMotionInfo[0];
	if(motionType === 'scroll') {
		this.updateBackgroundScroll();
	} else if(motionType === 'zoom') {
		this.updateBackgroundZoom();
	} else if(motionType === 'rotate') {
		this.updateBackgroundRotate();
	} else if(motionType === 'blur' && this._backgroundMotionFilter) {
		this.updateBackgroundBlur();
	}
};

Scene_MenuBase.prototype.updateBackgroundScroll = function() {
	this._backgroundSprite.origin.x += this._backgroundMotionInfo[1];
	this._backgroundSprite.origin.y += this._backgroundMotionInfo[2];
};

Scene_MenuBase.prototype.updateBackgroundZoom = function() {
	this._backgroundSprite.scale.x += (this._backgroundMotionInfo[1] * this._backgroundMotionSign);
	this._backgroundSprite.scale.y += (this._backgroundMotionInfo[1] * this._backgroundMotionSign);
	if(this._backgroundSprite.scale.x >= this._backgroundMotionInfo[2] || this._backgroundSprite.scale.x <= this._backgroundMotionScale) {
		this._backgroundMotionSign *= (-1);
	}
};

Scene_MenuBase.prototype.updateBackgroundRotate = function() {
	this._backgroundSprite.rotation += (this._backgroundMotionInfo[1] * this._backgroundMotionSign);
	if(this._backgroundMotionInfo[2]) {
		if(Math.abs(this._backgroundSprite.rotation) > this._backgroundMotionInfo[2]) {
			this._backgroundMotionSign *= (-1);
		}
	} else {
		if(this._backgroundSprite.rotation > (Math.PI*2)) {
			this._backgroundSprite.rotation -= (Math.PI*2);
		} else if(this._backgroundSprite.rotation < (Math.PI*2)) {
			this._backgroundSprite.rotation += (Math.PI*2);
		}
	}
};

Scene_MenuBase.prototype.updateBackgroundBlur = function() {
	this._backgroundMotionFilter.blur += (this._backgroundMotionInfo[1] * this._backgroundMotionSign);
	if(Math.abs(this._backgroundMotionFilter.blur) > this._backgroundMotionInfo[2]) {
		this._backgroundMotionSign *= (-1);
	}
};

})(SRD.MenuBackgrounds);